package com.hero.objects.talents;

import org.jdom.Element;

import com.hero.ui.dialog.CombatLuckDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CombatLuck extends Talent {

	private static String xmlID = "COMBAT_LUCK";

	protected boolean affectsPrimary;

	protected boolean affectsTotal;

	public CombatLuck(Element root) {
		super(root, CombatLuck.xmlID);
		setLevels(getLevels());
	}

	public boolean getAffectPrimary() {
		return affectsPrimary;
	}

	public boolean getAffectTotal() {
		if (affectsPrimary) {
			affectsTotal = true;
		}
		return affectsTotal;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		CombatLuckDialog dialog = new CombatLuckDialog(this, isNew, isPower);
		return dialog;
	}

	public int getEdIncrease() {
		return 3;
	}

	public int getEdIncreaseLevels() {
		return 1;
	}

	public int getPdIncrease() {
		return 3;
	}

	public int getPdIncreaseLevels() {
		return 1;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("LEVELS", "" + getLevels());
		root.setAttribute("AFFECTS_PRIMARY", getAffectPrimary() ? "Yes" : "No");
		root.setAttribute("AFFECTS_TOTAL", getAffectTotal() ? "Yes" : "No");
		return root;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "AFFECTS_PRIMARY");
		if ((check != null) && (check.trim().length() > 0)) {
			affectsPrimary = check.trim().toUpperCase().startsWith("Y");
		}
		check = XMLUtility.getValue(root, "AFFECTS_TOTAL");
		if ((check != null) && (check.trim().length() > 0)) {
			affectsTotal = check.trim().toUpperCase().startsWith("Y");
		}
	}

	public void setAffectPrimary(boolean val) {
		affectsPrimary = val;
	}

	public void setAffectTotal(boolean val) {
		affectsTotal = val;
	}

	@Override
	public void setLevels(int val) {
		super.setLevels(val);
		String ret = getDisplay();
		int pd = getPdIncrease() * getLevels() / getPdIncreaseLevels();
		int ed = getEdIncrease() * getLevels() / getEdIncreaseLevels();
		ret += " (" + pd + " PD/" + ed + " ED)";
		setAlias(ret);
	}

}